/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.items;

import java.util.List;
import java.util.Optional;
import mod.traister101.sns.common.SNSItemTags;
import mod.traister101.sns.common.capability.ContainerItemHandler;
import mod.traister101.sns.common.capability.ILunchboxHandler;
import mod.traister101.sns.common.capability.LunchboxCapability;
import mod.traister101.sns.common.capability.LunchboxFoodTrait;
import mod.traister101.sns.common.items.ContainerItem;
import mod.traister101.sns.util.ContainerType;
import mod.traister101.sns.util.SNSUtils;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class LunchBoxItem
extends ContainerItem {
    public static final String SELECTED_SLOT_TOOLTIP = "sns.tooltip.lunchbox.selected_slot";

    public LunchBoxItem(Item.Properties properties, ContainerType type) {
        super(properties, type);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            return heldStack.getCapability(LunchboxCapability.LUNCHBOX).map(lunchboxHandler -> {
                ItemStack targetFood = lunchboxHandler.getSelectedStack();
                if (targetFood.m_41619_()) {
                    return InteractionResultHolder.m_19098_((Object)heldStack);
                }
                FoodProperties targetFoodProperties = targetFood.getFoodProperties((LivingEntity)player);
                if (!targetFood.m_41619_() && !player.m_36335_().m_41519_(targetFood.m_41720_()) && player.m_36391_(targetFood.m_41614_() && targetFoodProperties != null && targetFoodProperties.m_38747_())) {
                    player.m_6672_(hand);
                    return InteractionResultHolder.m_19096_((Object)heldStack);
                }
                return InteractionResultHolder.m_19098_((Object)heldStack);
            }).orElseGet(() -> InteractionResultHolder.m_19098_((Object)heldStack));
        }
        if (!level.f_46443_ && player.m_6144_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)LunchBoxItem.createMenuProvider(player, hand, heldStack), byteBuf -> {
                byteBuf.writeBoolean(hand == InteractionHand.MAIN_HAND);
                byteBuf.writeInt(this.type.getSlotCount());
                byteBuf.writeInt(this.type.getSlotCapacity());
            });
            return InteractionResultHolder.m_19096_((Object)heldStack);
        }
        return InteractionResultHolder.m_19098_((Object)heldStack);
    }

    @Override
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)SELECTED_SLOT_TOOLTIP, (Object[])new Object[]{SNSUtils.intComponent(itemStack.getCapability(LunchboxCapability.LUNCHBOX).map(ILunchboxHandler::getSelectedSlot).orElse(0) + 1).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
            super.m_7373_(itemStack, level, tooltip, flagIn);
            return;
        }
        super.m_7373_(itemStack, level, tooltip, flagIn);
    }

    @Override
    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        return super.m_142422_(itemStack);
    }

    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        return itemStack.getCapability(LunchboxCapability.LUNCHBOX).map(itemHandler -> itemHandler.consumeSelected(itemStack, level, livingEntity)).orElse(itemStack);
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.EAT;
    }

    public int m_8105_(ItemStack itemStack) {
        return itemStack.getCapability(LunchboxCapability.LUNCHBOX).map(lunchboxHandler -> lunchboxHandler.getSelectedStack().m_41779_()).orElse(32);
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack itemStack, @Nullable LivingEntity entity) {
        Optional capability = itemStack.getCapability(LunchboxCapability.LUNCHBOX).resolve();
        return capability.map(lunchboxHandler -> lunchboxHandler.getSelectedFoodProperties(entity)).orElse(null);
    }

    public static class LunchboxHandler
    extends ContainerItemHandler
    implements ILunchboxHandler {
        public static final String SELECTED_SLOT_KEY = "selectedSlot";
        private int selectedSlot = 0;

        public LunchboxHandler(ContainerType type) {
            super(type);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = super.serializeNBT();
            compoundTag.m_128405_(SELECTED_SLOT_KEY, this.selectedSlot);
            return compoundTag;
        }

        @Override
        public void deserializeNBT(CompoundTag compoundTag) {
            super.deserializeNBT(compoundTag);
            this.selectedSlot = compoundTag.m_128451_(SELECTED_SLOT_KEY);
        }

        @Override
        public boolean isItemValid(int slotIndex, ItemStack itemStack) {
            return itemStack.m_204117_(SNSItemTags.LUNCHBOX_FOOD) && super.isItemValid(slotIndex, itemStack);
        }

        public void setStackInSlot(int slotIndex, ItemStack itemStack) {
            FoodCapability.applyTrait((ItemStack)itemStack, (FoodTrait)LunchboxFoodTrait.LUNCHBOX);
            super.setStackInSlot(slotIndex, itemStack);
        }

        public ItemStack insertItem(int slotIndex, ItemStack itemStack, boolean simulate) {
            ItemStack insert = itemStack.m_41777_();
            FoodCapability.applyTrait((ItemStack)insert, (FoodTrait)LunchboxFoodTrait.LUNCHBOX);
            ItemStack remainder = super.insertItem(slotIndex, insert, simulate);
            FoodCapability.removeTrait((ItemStack)remainder, (FoodTrait)LunchboxFoodTrait.LUNCHBOX);
            return remainder;
        }

        public ItemStack extractItem(int slotIndex, int amount, boolean simulate) {
            ItemStack extractItem = super.extractItem(slotIndex, amount, simulate);
            FoodCapability.removeTrait((ItemStack)extractItem, (FoodTrait)LunchboxFoodTrait.LUNCHBOX);
            return extractItem;
        }

        @Override
        public ItemStack getSelectedStack() {
            return this.getStackInSlot(this.getSelectedSlot());
        }

        @Override
        public void cycleSelected(ILunchboxHandler.CycleDirection cycleDirection) {
            int nextSelection = this.selectedSlot + (switch (cycleDirection) {
                default -> throw new IncompatibleClassChangeError();
                case ILunchboxHandler.CycleDirection.FORWARD -> 1;
                case ILunchboxHandler.CycleDirection.BACKWARD -> -1;
            });
            if (nextSelection >= this.getSlots()) {
                nextSelection -= this.getSlots();
            }
            if (nextSelection < 0) {
                nextSelection += this.getSlots();
            }
            this.selectedSlot = nextSelection;
            assert (this.selectedSlot >= 0 && this.selectedSlot < this.getSlots()) : String.format("Selected Slot: %s must be a valid slot index in range [0,%s)", this.selectedSlot, this.getSlots());
        }

        @Override
        public ItemStack consumeSelected(ItemStack itemStack, Level level, LivingEntity livingEntity) {
            ItemStack food = this.extractItem(this.getSelectedSlot(), 1, false);
            livingEntity.m_5584_(level, food);
            while (this.getSelectedStack().m_41619_() && this.getSelectedSlot() != 0) {
                this.cycleSelected(ILunchboxHandler.CycleDirection.BACKWARD);
            }
            return itemStack;
        }

        @Override
        public int getSelectedSlot() {
            return this.selectedSlot;
        }
    }
}

